using System;
using System.IO;
using DynaPDF;

namespace examples
{
	class Hello_World
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diCreator, "C# test application");
            pdf.SetDocInfo(DynaPDF.TDocumentInfo.diTitle, "Hello World");

            pdf.SetPageCoords(DynaPDF.TPageCoord.pcTopDown); // We use top down coordinates in this example
            pdf.Append(); // An an empty page to the file
            pdf.SetFont("Arial", DynaPDF.TFStyle.fsItalic, 20.0, true, DynaPDF.TCodepage.cp1252);  // Before printing text you must set a font
            pdf.WriteText(50.0, 50.0, "My first PDF output..."); // Write some text
            pdf.WriteText(50.0, 80.0, "File created: " + DateTime.Now.ToString());
            pdf.EndPage(); // Close the open page

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
